#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_i2c.h"
#include "hal_irq.h"

i2c_handle_t i2c_handle;	// i2cṹ
uint8_t write[5];			// Ҫ͵buffer
uint8_t read[5];			// նȡbuffer
hal_status_t status;		// պ״̬
uint8_t loop;				// ִдͳ

/* PB4 SCL; PB5 SDA˿ڳʼΪ©ʹ */
void GPIO_init(void)
{
	gpio_init_t init;
	init.io = GPIO_INPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_DIGIT_MODE;
	init.pu = ENABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	init.smit = GPIO_1_5_TO_3_0_SMIT;
	init.cur_ctr = DISABLE;
	gpio_init(PB_TYPE, GPIO_PIN_4, &init);
	gpio_init(PB_TYPE, GPIO_PIN_5, &init);
}

/* жϷʹжϣINVT = 00I2CIG6УжڵַΪ0x0020 */
void irq_iic(void) interrupt_low 0x0020
{
	irq_i2c_handle(&i2c_handle);
}

void main() 
{
	// RAMʼ
	ram_clear();
	// ι
	CLRWDT();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);

	// ʼbuffer
	for (loop = 0; loop < 5; loop++)
		write[loop] = loop + 1;

	//ʼI2C_SLAVER
	i2c_handle.addr = 0xA0;
	i2c_init(&i2c_handle);

	 //ѡжģʽ
	INTVEN0 = 1;
	//ʹܵȼж
	GIEL    = 1;
	// ʹж
	IRQ_GIE_CFG(1);
	// ʹI2Cж
	irq_config(I2CIE_IT, ENABLE);

	/* ͵bufferi2c_handlerڲ
	   ע⣺1.ͺͽղͬʱ
	         2.ڷͻǰ */
	//i2c_tx_by_irq(&i2c_handle, write, 5);


	/* յbufferi2c_handlerڲ */
	i2c_rx_by_irq(&i2c_handle, read, 5);


	while (1) {
		// ι
		CLRWDT();
	}

}